/********************************************************/
/*  Pendu Mathématique par Troumad alias Bernard SIAUD  */
/*           À visiter sur http://troumad.org           */
/*  Avec les remerciments à http://www.developpez.com   */
/********************************************************/

#include "pendu.h"                                                  /* Comme si on remplace cette ligne par TOUT le FICHIER pendu.h */
#include <errno.h>
/*#include <linux/unistd.h>*/
/* #include <unistd.h> à remplacer par : */
#include <stdio.h>

/* exemple de défintion de variables globales */
/* format nom=init */                                               /* Les variables sont déclarées en extern dans pendu.h          */
                                                                    /* Elles sont initialisées une seule fois ici                   */

/**/

int main(int argc, char **argv)
{
 GtkWidget *p_main_box = NULL;                                      /* le conteneur principal                                       */
 GtkWidget *p_window = NULL;                                        /* la fenêtre                                                   */
 GtkWidget * total=NULL;
 GtkWidget * menu=NULL;
 GtkWidget * es1=NULL;
 GtkWidget * es2=NULL;
 GtkWidget * mes=NULL;
 GtkWidget * vertical=NULL;
 GtkWidget * vertical1=NULL;
 GtkWidget * bouton=NULL;
 GtkAccelGroup *accel_group;                                        /* Pour les raccourcis claviers                                 */
 
 gpointer * donnees;
 GtkWidget * donneesW[NB_GTKWIDGET];
 GdkPixbuf * donneesP[1];
 FILE      * donneesF[1];
 
 GError *error=NULL;
 GtkUIManager *menu_Manager;
 char nom[46];
  
 /* le menu est défini par ce tableau */
 GtkActionEntry entrees_menu[] =
 {
  /* nom de l'action  , icone         , affichage du menu  , rac clavier, commentaires       , fonction callback      */
  {"FichierMenuAction",NULL           ,"Jeu"               , NULL       , NULL               ,NULL                     },
  {"NouvelleOperation",GTK_STOCK_OPEN ,"Nouvelle Operation","<Control>O","Change l'operation",G_CALLBACK(nv_operation )},
  {"NouveauxNombres"  ,GTK_STOCK_FILE ,"Nouveau nombres"   ,"<Control>N","Change les nombres",G_CALLBACK(nv_nombres   )},
  {"Valider"          ,GTK_STOCK_OK   ,"Valider"           ,"<Alt>V"    ,"Valider"           ,G_CALLBACK(valide       )},
  {"Quitter"          ,GTK_STOCK_QUIT ,"Quitter"           ,"<Control>Q","Finir la partie"   ,G_CALLBACK(cb_fin       )},
  {"AideMenuAction"   ,NULL           ,"Aide"              , NULL       , NULL               ,NULL                     },
  {"Aide"             ,GTK_STOCK_HELP ,"Aide"              ,"<Shift>A"  , NULL               ,G_CALLBACK(menu_aide    )},
  {"AproposAction"    ,GTK_STOCK_ABOUT,"A propos"          ,"<Alt>A"    , NULL               ,G_CALLBACK(menu_a_propos)},
  {"Licence"          ,GTK_STOCK_INFO ,"Licence GPL"       ,"<Release>L", NULL               ,G_CALLBACK(menu_licence )}
 };                                                                 /*voir gtk_action_group_add_actions pour les paramètres à passer*/
 GtkActionGroup * p_actionGroup;
 
 cd_prog(argv[0]);
 
 donnees=(gpointer *)malloc(3*sizeof(gpointer));
 donnees[0]=(gpointer *)donneesW;
 donnees[1]=(gpointer *)donneesP;
 donnees[2]=(gpointer *)donneesF;
 
 gtk_init (&argc, &argv);                                           /* Initialisation de GTK+                                       */
 
 nom[0]=0;
 fenetre_nom(nom,"Quel sont votre prémon et votre nom ?");
 if (nom[0]==0)
  strcpy(nom,"traces/sortie.pendu");
 FICHIER=fopen(nom,"w");
 if (FICHIER==NULL)
 {
  perror (NULL);
  printf("\nFICHIER %s impossible à ouvrir.\n",nom);
  return 0;
 }                                 /* définition du FICHIER de sortie                               */
 fprintf(FICHIER,"<partie>\n");                                     /* première balise pour un style xml                            */
 
 /****************************************************************************/
 /*     Le corps du programme ne fait que la mise en page de l'interface     */
 /*    La gestion de l'interaction se fait avec des routines extérieures     */
 /*                          au corps du programme.                          */
 /*       Ces autres routines sont livrées dans d'autre(s) FICHIER(s)        */
 /****************************************************************************/
 p_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);                    /* mise ne place de la fenêtre principale                       */
 if (p_window==NULL) return 0;                                      /* mise en place impossible => sortie du programme              */
 gtk_window_set_title (GTK_WINDOW (p_window),"Pendu Mathématique"); /* titre de la fenêtre                                          */
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (p_window),"troumad.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 total=gtk_vbox_new(FALSE,0);                                       /* boite horizontale principale                                 */
 if (total==NULL) return 0;
 gtk_container_add (GTK_CONTAINER (p_window), total);               /* insertion de la boite horizontale dans la principale         */
 menu=gtk_vbox_new(FALSE,0);                                        /* définition d'une boite verticale pour mettre le menu         */
 if (menu==NULL) return 0;
 gtk_box_pack_start(GTK_BOX(total),menu,FALSE,FALSE,0);             /* insertion de cette boite dans la boite horizontale           */
 
 /******************************************************************************/
 /* activation du menu : http://nicolasj.developpez.com/articles/gtkuimanager/ */
 /******************************************************************************/
 menu_Manager = gtk_ui_manager_new ();
 if (menu_Manager==NULL) return 0; 
 gtk_ui_manager_set_add_tearoffs (menu_Manager,TRUE);               /* possibilité de mise en fenêtre des menus                     */
 gtk_ui_manager_add_ui_from_file(menu_Manager,"main.menu.xml",&error);
 if (error!=NULL) 
 {
  traite_erreur(error);
  free(error);
  printf("Erreur dans la mise en place du menu\n");
 }
 g_signal_connect(menu_Manager,"add_widget",G_CALLBACK( menu_addWidget ),GTK_CONTAINER(menu));
 p_actionGroup = gtk_action_group_new( "menuActionGroup" );
 if (p_actionGroup==NULL) return 0;
 gtk_action_group_add_actions( p_actionGroup, entrees_menu, G_N_ELEMENTS( entrees_menu ), donnees ); /* Dernier argument données à  */
                                                                    /* passer aux fonctions callback                                */
 gtk_ui_manager_insert_action_group( menu_Manager, p_actionGroup, 0 );
 /******************************************************/
 /*  manipulation pour activer les raccourcis clavier  */
 accel_group = gtk_ui_manager_get_accel_group (menu_Manager);       /* Création de l'AccelGroup à partir du GtkActionEntry          */
 gtk_window_add_accel_group (GTK_WINDOW (p_window), accel_group);   /* Activation des raccourcis clavier à partir de l'AccelGroup   */
 /******************************************************/

 p_main_box=gtk_hbox_new(FALSE,0); /* défintion d'une boite horizontale pour mettre le pendu à droite et l'intercation à gauche     */
 if (p_main_box==NULL) return 0; 
 gtk_box_pack_start(GTK_BOX(total),p_main_box,FALSE,FALSE,0);  /* insertion de cette boite dans la boite horizontale principale     */
 es1=gtk_vbox_new(TRUE,0);         /* es1 et es2  ne sont là que pour la présentation : faire de l'espace autour de l'interaction   */
 if (es1==NULL) return 0; 
 vertical=gtk_vbox_new(TRUE,0);    /* fenêtre avec les messages et l'interaction                                                    */
 es2=gtk_vbox_new(TRUE,0);
 if (es2==NULL) return 0; 
 gtk_widget_set_size_request(es1,100,-1);    /* imposition d'une largeur à es1 et es2 : étant vides ils seraient de largeur nulle   */
 gtk_widget_set_size_request(es2,100,-1);    /* le -1 comme hauteur signale de prendre la valeur par défaut                         */
 /****************************************************************************/
 /* Définition de la boite verticale dans laquelle se trouvent les écritures */
 /****************************************************************************/
 AFF_OPERATION=gtk_label_new("");                                   /* initailisation d'un label                                    */
 if (AFF_OPERATION==NULL) return 0; 
 gtk_label_set_justify(GTK_LABEL(AFF_OPERATION),GTK_JUSTIFY_RIGHT); /* imposition d'un alignement à droite                          */
 gtk_box_pack_start(GTK_BOX(vertical),AFF_OPERATION,FALSE,FALSE,0); /* mise en place du label pour les messages                     */
 /****************************************************************************/
 /*     insertion d'une autre boite verticale afin de reserrer les items     */
 /*       qui vont avec le choix des chiffres : label de présentation,       */
 /*                    COMBO du choix et bouton validation                   */
 /****************************************************************************/ 
 vertical1=gtk_vbox_new(TRUE,0);
 if (vertical1==NULL) return 0; 
 gtk_box_pack_start(GTK_BOX(vertical),vertical1,FALSE,FALSE,0);     
 gtk_widget_set_size_request(vertical1,-1,130);                     /* imposition d'une hauteur à cette boite                       */
 mes=gtk_label_new("Choisissez votre chiffre\net Validez :");       /* label de présentation                                        */
 if (mes==NULL) return 0; 
 gtk_label_set_justify(GTK_LABEL(mes),GTK_JUSTIFY_CENTER);          /* l'écriture de sera centrée                                   */
 gtk_box_pack_start(GTK_BOX(vertical1),mes,FALSE,FALSE,0);          /* insertion de la sous boite                                   */
 COMBO = gtk_combo_box_new_text();                                  /* la liste de sélection sera initialisée plus tard             */
 if (COMBO==NULL) return 0; 
 gtk_widget_set_size_request(COMBO,20,-1);                          /* imposition d'une largeur à la liste de sélection : inactif :(*/
 gtk_box_pack_start(GTK_BOX(vertical1),COMBO,FALSE,FALSE,0);        /* placement du COMBO dans la sous boite                        */
 bouton=gtk_toggle_button_new_with_label("Valider");                /* bouton avec le texte "Valider"                               */
 if (bouton==NULL) return 0; 
 gtk_box_pack_start(GTK_BOX(vertical1),bouton,FALSE,FALSE,0);       /* mise en place du bouton, si on clique sur se bouton, on      */
 g_signal_connect(GTK_OBJECT(bouton),"toggled", G_CALLBACK (valide),donnees);/* appellera la fonction valide                        */
 AFF_PARTIE=gtk_label_new("");                                  /*initialisation du label qui affichera le nombre de parties gagnées*/
 if (AFF_PARTIE==NULL) return 0; 
 gtk_box_pack_start(GTK_BOX(vertical1),AFF_PARTIE,FALSE,FALSE,0);   /* mise en place de ce label                                    */
 /****************************************************************************/ 
 /*               Fin de la boite autour du choix des chiffres               */
 /****************************************************************************/ 
 gtk_box_pack_start(GTK_BOX(p_main_box),es1,FALSE,FALSE,0);         /* mise en place des boites es1, vertical et es2 dans la boite  */
 gtk_box_pack_start(GTK_BOX(p_main_box),vertical,FALSE,FALSE,0);    /* dans la boite principale, l'ordre de gauche à droite sera :  */
 gtk_box_pack_start(GTK_BOX(p_main_box),es2,FALSE,FALSE,0);         /* es1 vertical es2                                             */
 /****************************************************************************/ 
 /*                   Fin de la mise en page des écritures                   */
 /****************************************************************************/ 
 
 /****************************************************************************/ 
 /*                          Mise en place du dessin                         */
 /****************************************************************************/ 
 VIDE=gdk_pixbuf_new_from_file("vide.png",&error);                   /* on début la case du pendu est vide                          */
 if (VIDE==NULL)
 {
  traite_erreur(error);
  free(error);
  return 0;
 }
 PENDU=gtk_image_new_from_pixbuf(VIDE);                             /* on affecte cette image à un élément affichable               */
 if (PENDU==NULL) return 0; 
 gtk_box_pack_start(GTK_BOX(p_main_box),PENDU,FALSE,FALSE,0);       /* on le met en place en dernier : il sera à droite de es2      */
 nouv_nombres(donnees);                                             /* initialisation des nombres                                   */
 /****************************************************************************/
 /*                     Fin de la mise en place du dessin                    */
 /****************************************************************************/
 
 g_signal_connect (G_OBJECT (p_window), "destroy", G_CALLBACK (cb_fin),donnees);/*appel de cb_fin si destruction de boite principale*/

 gtk_widget_show_all (p_window);                              /* on active l'affichage la boite principale et tout ce qui est dedans*/
 
 gtk_main ();                                                       /* on active la boite principale : le jeu est lancé             */

 return 1;
}
