#!/bin/sh

# Racine du site sur votre PC,  adapter
racine="/maison_1/bs/sites/Troumad"

# License GPL bien sur ;)
# ce script attend en paramtre un nom de fichier qui peut tre 
# donn sous forme d'un chemin relatif ou absolu.

# Maniement de Chane par
# Christophe Gaubert http://perso.wanadoo.fr/christophe.gaubert

# Une fonction qui affiche le message d'usage et sort.
# j'utilise ce qui s'appelle un Here-document :
# http://abs.traduc.org/abs-3.6-fr/here-docs.html
# comme ce que tu donne  ftp
usage()
{
 cat <<EOF
 Utilisation :
 "ftpsite --help"     pour avoir ses informations
 "ftpsite fichiers/rpertoire [fichiers/rpertoire] [fichiers/rpertoire]..."
                               pour transfrer les fichiers/rpertoires sits
 "ftpsite" pour transfrer tout le rpertoire courant et ses sous rpertoires
EOF

 exit 0
}

copieftp()
{
# On a repr le cas o le chemin est /maison_1/bs/sites/Troumad pour donner ./
 if [ -f "$1" ] ; then
  fichier=$1
  l=`echo $[ ${#fichier} - 1]`
  if [ "${fichier:$l}" != "~" ] ; then
   echo "put $1" >> ~/script/lock.sh
  else
   rm "$1"
  fi
 elif [ -r "$1" ] ; then
  echo "lcd $1" >> ~/script/lock.sh
  if [ "$PWD/$1" != "$racine" ] ; then
  #echo "$PWD$1 != $racine"
  echo "mkdir $1" >> ~/script/lock.sh
  #echo "lcd $1" >> ~/script/lock.sh
  echo "cd $1" >> ~/script/lock.sh
  fi
  cd $1
  for fich in * ; do
   # viter le problme du rpertoire sans droit de lecture
   # autre mthode : for file in `ls 2>/dev/null`; do
   [ "$fich" != "*" ] && copieftp "$fich"
  done
  echo "lcd .." >> ~/script/lock.sh
  echo "cd .." >> ~/script/lock.sh
  cd ..
 fi
}

# on commence par vrifier qu'il a bien reu un argument et que
# celui-ci correspond  un fichier, sinon on sort. 
if [ $# == 0 ] ; then
 a=$PWD
 cd ..
 ~/script/ftpsite.sh "$a/"
 exit $?
fi
# recherche du paramtre pass
case "$1" in
    --help)
        usage
        ;;
       *)
        a=0
	# parcours des paramtres
        while [ $# -gt 0 ]; do
         # on spare le nom du fichier de la partie correspondant au
         # rpertoire :
         filename=$(echo `basename $1`)
         dirname=$(echo `dirname $1`)
         # maintenant :
         # - filename est le nom ("strict") du fichier
         # - dirname est le rpertoire dans lequel se trouve ce fichier, a
         # peut tre un chemin relatif (comme "../..) ou un chemin absolu
         # (comme /usr/local/src)
         # NB : on devrait pouvoir faire cette sparation par simple manipulation
         # de la chaine $1, sans faire appel  basename et dirname.
         # Optimisation laisse en exercice ;)
         # Puis on transforme le chemin ventuellement relatif en chemin absolu
         # en faisant appel  pwd :
         old_pwd=$(pwd) # au cas o on voudrait y revenir
         cd "$dirname"
         dirname=$(pwd)
         # maintenant : dirname est le chemin absolu du rpertoire qui contient
         # le fameux fichier
         # et il ne reste plus qu' l'analyser :
         # - soit il commence par /maison_1/bs/sites/Troumad
         #                => on supprime /maison_1/bs/sites/Troumad pour ne garder que la suite
         #                   du chemin
         # - soit il ne commence pas par /maison_1/bs/sites/Troumad
         #                => on sort
         # traiter le premier argument
         case "$dirname/$filename" in
         $racine*)
          # rpertoire  modifier selon votre configuration ligne du dessus et du dessous
          chemin=${dirname#$racine}
          if [ -z "$chemin" ] ; then
           chemin="./"
          else
           chemin=${chemin#/}
          fi
         ;;
         *)
          echo "error : rpertoire non valide"; exit 1
         ;;
         esac
         if [ -e "~/script/lock.sh" ] ; then
          echo "erreur dans la cration de ~/script/lock.sh"
          exit 1
         fi
	 # unftp contient le dbut du fichier de commande pour le ftp,
         cp ~/script/unftp.sh ~/script/lock.sh
	 # nous allonsconstruire la suite dans lock.sh
         chmod +x ~/script/lock.sh
         echo "cd $chemin" >> ~/script/lock.sh
         copieftp "$filename"
         [ $? = 1 ] && exit 1
         cd "$dirname"
         echo "bye" >> ~/script/lock.sh
         for fich in ~/script/site/* ; do
          # appel de lock.sh une fois par ftp trouv dans le rpertoire site
          ~/script/lock.sh $fich
         done

         #less ~/script/lock.sh
         rm -f ~/script/lock.sh

         cd "$old_pwd"
         shift # dcale les arguments d'un cran :
         #   $1 <- $2, $2 <- $3 ...
        done
        exit $a
        ;;
esac

